#version 420

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform mat4 modelMatrix;


in vec3 in_Vertex;
in vec3 in_Normal;
in vec2 in_TexCoord;

out mat3 normal_matrix;
out vec4 world_pos;
out vec3 out_normal;

mat3 GetLinearPart( mat4 m )
{
	mat3 result;
	
	result[0][0] = m[0][0]; 
	result[0][1] = m[0][1]; 
	result[0][2] = m[0][2]; 

	result[1][0] = m[1][0]; 
	result[1][1] = m[1][1]; 
	result[1][2] = m[1][2]; 
	
	result[2][0] = m[2][0]; 
	result[2][1] = m[2][1]; 
	result[2][2] = m[2][2]; 
	
	return result;
}		
	
void main()
{
	gl_Position = projectionMatrix * modelViewMatrix * vec4(in_Vertex,1.0);
	normal_matrix = GetLinearPart( modelMatrix );
	world_pos = modelMatrix * vec4(in_Vertex, 1.0);	
	out_normal = in_Normal;
}